<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class JobApplicationAnswer extends Model
{
    protected $table = 'job_application_answers';
    protected $primaryKey = 'Answer_id';
    public $timestamps = false;

    protected $fillable = [
        'Application_id',
        'Question_id',
        'Answer_text',
        'Answer_choice',
        'Answer_rating',
        'Answer_boolean',
        'Score',
    ];

    protected $casts = [
        'Answer_choice' => 'array',
        'Answer_rating' => 'integer',
        'Answer_boolean' => 'boolean',
        'Score' => 'decimal:2',
        'Created_at' => 'datetime',
    ];

    public function application(): BelongsTo
    {
        return $this->belongsTo(JobApplication::class, 'Application_id', 'Application_id');
    }

    public function question(): BelongsTo
    {
        return $this->belongsTo(JobQuestion::class, 'Question_id', 'Question_id');
    }
}
